<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_imabapi
 *
 * @copyright   Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
class ImabapiController extends JControllerLegacy
{
    var $images = '';

    public function display($cachable = false, $urlparams = false)
    {
        $rest_api = array();
        $config = JFactory::getConfig();
        $rest_api['url'] = JURI::base();
        $rest_api['sitename'] = $config->get('sitename');

        $rest_api['routes'][] = array(
            'namespace' => '/',
            'methods' => 'GET',
            'endpoints' => array('args' => array('option' => array(
                        'value' => 'com_imabapi',
                        'required' => true,
                        'type' => 'permanent'))),
            '_links' => JURI::base() . 'index.php?option=com_imabapi',
            );

        $rest_api['routes'][] = array(
            'namespace' => '/categories',
            'methods' => 'GET',
            'endpoints' => array('args' => array(
                    'option' => array(
                        'value' => 'com_imabapi',
                        'required' => true,
                        'type' => 'permanent'),
                    'json' => array(
                        'value' => 'categories',
                        'required' => true,
                        'type' => 'permanent'),
                    )),
            '_links' => JURI::base() . 'index.php?json=categories&option=com_imabapi',
            );

        $rest_api['routes'][] = array(
            'namespace' => '/content',
            'methods' => 'GET',
            'endpoints' => array('args' => array(
                    'option' => array(
                        'value' => 'com_imabapi',
                        'required' => true,
                        'type' => 'permanent'),
                    'json' => array(
                        'value' => 'content',
                        'required' => true,
                        'type' => 'permanent'),
                    'catid' => array(
                        'value' => '(?P<catid>[\\d]+)',
                        'description' => 'Categories ID',
                        'required' => false,
                        ),

                    )),
            '_links' => JURI::base() . 'index.php?json=content&option=com_imabapi');

        $rest_api['routes'][] = array(
            'namespace' => '/content_single',
            'methods' => 'GET',
            'endpoints' => array('args' => array(
                    'option' => array(
                        'value' => 'com_imabapi',
                        'required' => true,
                        'type' => 'permanent'),
                    'json' => array(
                        'value' => 'content_single',
                        'required' => true,
                        'type' => 'permanent'),
                    'id' => array(
                        'required' => true,
                        'value' => '(?P<id>[\\d]+)',
                        'description' => 'Content ID',
                        ),

                    )),
            '_links' => JURI::base() . 'index.php?option=com_imabapi&json=content_single&id=');

        header('Content-type: application/json');
        header('Access-Control-Allow-Origin: *');
        echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
        jexit();
    }

    public function route()
    {
        $rest_api = array();
        header('Content-type: application/json');
        header('Access-Control-Allow-Origin: *');
        echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
        jexit();
    }


    /**
     * ImabapiController::categories()
     * 
     * @return void
     */
    public function categories()
    {
        $rest_api = array();
        $db = JFactory::getDbo();
        $db->query(true);
        $query = "SELECT * FROM `#__categories` WHERE `extension`  = 'com_content' AND `published`=1";
        $db->setQuery($query);
        $items = $db->loadAssocList();
        $z = 0;
        foreach ($items as $item)
        {
            $rest_api[$z]["id"] = $item["id"];
            $rest_api[$z]["title"] = $item["title"];
            $rest_api[$z]["alias"] = $item["alias"];
            $rest_api[$z]["modified_time"] = $item["modified_time"];
            $rest_api[$z]["hits"] = $item["hits"];

            $rest_api[$z]["image"] = $this->images;
            $rest_api[$z]["description"] = "";

            $rest_api[$z]["link"]['self'] = JURI::base() . '?option=com_imabapi&json=categories';
            $rest_api[$z]["link"]['content'] = JURI::base() . 'index.php?catid=' . $item["id"] . '&option=com_imabapi&json=content';

            if (isset($item["description"]))
            {
                $rest_api[$z]["description"] = $item["description"];
            }
            if (isset($item["params"]))
            {
                $params = json_decode($item["params"], true);
                if ((isset($params['image'])) && ($params['image'] != ""))
                {
                    $rest_api[$z]["image"] = JURI::base() . $params['image'];
                }
            }
            $z++;
        }
        header('Content-type: application/json');
        header('Access-Control-Allow-Origin: *');
        echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
        jexit();
    }

    /**
     * ImabapiController::content()
     * 
     * @return void
     */
    function content()
    {
        $rest_api = array();
        include_once JPATH_ROOT . '/components/com_content/models/articles.php';
        $model = new ContentModelArticles();

        if (substr(JVERSION, 0, 1) == '2')
        {
            if (isset($_GET['catid']))
            {
                $model->setState('filter.category_id', (int)$_GET['catid']);
            }
        } elseif (substr(JVERSION, 0, 1) == '3')
        {
            $model->setState('filter.category_id', $this->input->get('catid'));
        }


        $items = $model->getItems();
        foreach ($items as $item)
        {
            $rest_api[] = $item;
        }
        header('Content-type: application/json');
        header('Access-Control-Allow-Origin: *');
        echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
        jexit();
    }
    /**
     * ImabapiController::content_single()
     * 
     * @return void
     */
    function content_single()
    {
        $rest_api = array();
        include_once JPATH_ROOT . '/components/com_content/models/article.php';
        $model = new ContentModelArticle();


        if (substr(JVERSION, 0, 1) == '2')
        {
            if (isset($_GET['id']))
            {
                $rest_api = $model->getItem((int)$_GET['id']);
            }
        } elseif (substr(JVERSION, 0, 1) == '3')
        {
            $rest_api = $model->getItem($this->input->get('id'));
        }


        header('Content-type: application/json');
        header('Access-Control-Allow-Origin: *');
        echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
        jexit();
    }
}
