<?php

/**
 * @author Jasman <jasman@ihsana.com>
 * @copyright Ihsana IT Solutiom 2016
 **/


//example url: http://app-backend.com/fixer.php?value=3&base=usd


$flags = 'http://app-backend.com/flags'; // folder flags


if (!isset($_GET['base']))
{
    $_GET['base'] = 'usd';
}
if (!isset($_GET['value']))
{
    $_GET['value'] = 1;
}

$base = strtoupper($_GET['base']);
$api_url = 'http://api.fixer.io/latest?base=' . $base;
$json_data = json_decode(file_get_contents($api_url), true);
$symbols = array_keys($json_data['rates']);
$z = 0;
foreach ($symbols as $symbol)
{
    $rest_api[] = array(
        'id' => $z,
        'base_value' => $_GET['value'],
        'base_symbol' => $json_data['base'],
        'base_flag' => $flags . '/' . substr(strtolower($json_data['base']), 0, 2) . '.png',
        'date' => $json_data['date'],
        'rate_symbol' => $symbol,
        'rate_value' => ($json_data['rates'][$symbol]) * $_GET['value'],
        'rate_flag' => $flags . '/' . substr(strtolower($symbol), 0, 2) . '.png',
        );
    $z++;
}

header('Content-type: application/json');
header('Access-Control-Allow-Origin: *');
if (defined("JSON_UNESCAPED_UNICODE"))
{
    echo json_encode($rest_api, JSON_UNESCAPED_UNICODE);
} else
{
    echo json_encode($rest_api);
}

?>